<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
  public function run(): void
    {
        User::updateOrCreate(
            ['email' => 'admin@inaura.com'],
            [
                'name'     => 'Admin',
                'password' => Hash::make('password'),
                'role'     => 'admin',
            ]
        );

        User::updateOrCreate(
            ['email' => 'hrd@inaura.com'],
            [
                'name'     => 'HRD',
                'password' => Hash::make('password'),
                'role'     => 'hrd',
            ]
        );

        User::updateOrCreate(
            ['email' => 'user@inaura.com'],
            [
                'name'     => 'User',
                'password' => Hash::make('password'),
                'role'     => 'user',
            ]
        );
    }

}
